#include "MTListWindow.h"
#include "MTUtilities.h"
#include "MTApplication.h"

const UInt32	MTListWindow::kTextElementXOffset = 4;
const UInt32	MTListWindow::kTextElementYOffset = 3;

//	MTListWindow::MTListWindow()
//	
//	constructor
MTListWindow::MTListWindow()
{
	selection = 0;
}

//	MTListWindow::~MTListWindow()
//	
//	destructor
MTListWindow::~MTListWindow()
{
	
}

//	void MTListWindow::HandleOpenEvent(void)
//	
//	creates and inits scroll bars
void MTListWindow::HandleOpenEvent(void)
{
	UInt32	width = theWindow->portRect.right - theWindow->portRect.left;
	UInt32	height = theWindow->portRect.bottom - theWindow->portRect.top;
	SInt32	temp, viewSize;
	
	CreateScrollBars(0, 1);
	
	viewSize = height / GetItemHeight();
	temp = GetListLength() - viewSize;
	if(temp < 0)
		temp = 0;
	
	SetControl32BitMinimum(vertScroll, 0);
	SetControl32BitMaximum(vertScroll, temp);
	SetControl32BitValue(vertScroll, 0);
	SetControlViewSize(vertScroll, viewSize);
}

//	void MTListWindow::HandleCloseEvent(void)
//	
//	cleans up before closing window
void MTListWindow::HandleCloseEvent(void)
{
	
}

//	void MTListWindow::HandleContentEvent(EventRecord * theEvent, UInt32 flags)
//	
//	handles a mouse down event in the content region of the window
//	
//	theEvent = event record
//	flags = event flags
void MTListWindow::HandleContentEvent(EventRecord * theEvent, UInt32 flags)
{
	#pragma unused (flags)
	
	if(AutoHandleControls(theEvent))
	{
		if(SupportsSelection())
		{
			MTGrafPortSaver	saver(theWindow);
			Point			where, globalWhere;
			UInt32			base;
			Rect			contentRect;
			UInt32			originalSelection;
			UInt32			currentSelection;
			
			GetWindowBounds(theWindow, kWindowContentRgn, &contentRect);
			
			where = theEvent->where;
			
			GlobalToLocal(&where);
			
			base = GetControl32BitValue(vertScroll);
			
			currentSelection = originalSelection = selection = (where.v / GetItemHeight()) + base;
			
			HandleUpdateEvent();
			
			if(flags & kIsDoubleClick)
			{
				HandleListDoubleClick(selection);
			}
			else
			{
				while(StillDown())
				{
					GetMouse(&where);
					
					globalWhere = where;
					LocalToGlobal(&globalWhere);
					
					if(PtInRect(globalWhere, &contentRect))
					{
						currentSelection = (where.v / GetItemHeight()) + base;
					}
					else
					{
						if(globalWhere.v < contentRect.top)
						{
							if(base > 0)
							{
								SetControl32BitValue(vertScroll, base - 1);
								
								base--;
								currentSelection = base;
								
								DrawOneControl(vertScroll);
							}
						}
						else
						{
							if(globalWhere.v > contentRect.bottom)
							{
								if(base < GetControl32BitMaximum(vertScroll))
								{
									SetControl32BitValue(vertScroll, base + 1);
									
									base++;
									currentSelection = base + GetControlViewSize(vertScroll);
									
									DrawOneControl(vertScroll);
								}
							}
							else
							{
								currentSelection = originalSelection;
							}
						}
					}
					
					if(selection != currentSelection)
					{
						selection = currentSelection;
						
						HandleUpdateEvent();
					}
				}
			}
			
			SelectionChanged();
		}
	}
}

//	void MTListWindow::HandleResizeEvent(SInt32 newWidth, SInt32 newHeight)
//	
//	handles a resize event (moves scroll bars)
//	
//	newWidth = new window width
//	newHeight = new window height
void MTListWindow::HandleResizeEvent(SInt32 newWidth, SInt32 newHeight)
{
	MoveScrollBars(newWidth, newHeight);
	
	SInt32	newViewSize = newHeight / GetItemHeight();
	SInt32	temp;
	
	temp = GetListLength() - newViewSize;
	if(temp < 0)
		temp = 0;
	
	SetControlMaximum(vertScroll, temp);
	SetControlViewSize(vertScroll, newViewSize);
	
	Rect	bounds;
	
	bounds.left = 0;
	bounds.top = 0;
	bounds.right = newWidth;
	bounds.bottom = newHeight;
	
	InvalWindowRect(theWindow, &bounds);
}

//	void MTListWindow::HandleUpdateEvent(void)
//	
//	updates the window contents
void MTListWindow::HandleUpdateEvent(void)
{
	Rect			where, theRect;
	UInt32			width, height, length, y, count;
	SInt32			value;
	MTGrafPortSaver	saver(theWindow);
	
	GetWindowBounds(theWindow, kWindowContentRgn, &where);
	
	width = where.right - where.left;
	height = where.bottom - where.top;
	
	length = GetListLength();
	value = GetControl32BitValue(vertScroll);
	
	for(y = 0, count = 0; (y <= height) && ((count + value) < length); y += GetItemHeight(), count++)
	{
		theRect.left = 0;
		theRect.top = y;
		theRect.right = width - kScrollBarSize;
		theRect.bottom = y + GetItemHeight();
		
		SetThemePen(kThemeBrushListViewBackground, 32, 1);
		PaintRect(&theRect);
		
		if(count != 0)
		{
			if(GetDividerStatus(count + value))
				SetThemePen(kThemeBrushBlack, 32, 1);
			else
				SetThemePen(kThemeBrushListViewSeparator, 32, 1);
			
			MoveTo(0, y);
			Line(width - kScrollBarSize, 0);
		}
		
		if(((count + value) == selection) && SupportsSelection())
			DrawElement(count + value, 0, y, kListItemSelectedFlag);
		else
			DrawElement(count + value, 0, y, 0);
	}
	
	if((y < where.bottom) || ((count + value) >= length))
	{
		theRect.left = 0;
		theRect.top = y;
		theRect.right = width - kScrollBarSize;
		theRect.bottom = where.bottom;
		
		SetThemePen(kThemeBrushListViewBackground, 32, true);
		PaintRect(&theRect);
	}
	
	gTheApp->UpdateMenuState(kChangedMessageSupport);
}

//	void MTListWindow::HandleScrollEvent(MTWindowControlType which, SInt32 value)
//	
//	handles window scrolling
//	
//	which = which scroll bar is being scrolled
//	value = current value of scroll bar
void MTListWindow::HandleScrollEvent(MTWindowControlType which, SInt32 value)
{
	#pragma unused (which)
	#pragma unused (value)
	
	HandleUpdateEvent();
}

//	void MTListWindow::HandleControlEvent(ControlHandle theControl, SInt16 thePart)
//	
//	handles control click
//	
//	theControl = source control
//	thePart = part of control that recieved the click
void MTListWindow::HandleControlEvent(ControlHandle theControl, SInt16 thePart)
{
	#pragma unused (theControl)
	#pragma unused (thePart)
}

//	void MTListWindow::HandleButtonEvent(ControlHandle theControl)
//	
//	handles a click in a button
//	
//	theControl = source control
void MTListWindow::HandleButtonEvent(ControlHandle theControl)
{
	#pragma unused (theControl)
}

//	void MTListWindow::GetZoomSizeBounds(Rect * bounds)
//	
//	sets up rect containing maximum window zoom size bounds
//	
//	bounds = pointer to rect which will recieve new bounds
void MTListWindow::GetZoomSizeBounds(Rect * bounds)
{
	UInt32	screenWidth = qd.screenBits.bounds.right - qd.screenBits.bounds.left;
	UInt32	screenHeight = qd.screenBits.bounds.bottom - qd.screenBits.bounds.top;
	
	bounds->left = GetItemWidth();
	bounds->top = (16 * 2 * 2) + 16;
	
	if(IsHorzResizable())
		bounds->right = screenWidth;
	else
		bounds->right = GetItemWidth();
	
	bounds->bottom = screenHeight;
}

//	short MTListWindow::GetWindowType(void)
//	
//	returns window type
//	
//	returns window type (defproc id)
short MTListWindow::GetWindowType(void)
{
	return kWindowFullZoomGrowDocumentProc;
}

//	void MTListWindow::GetWindowSize(Rect * theRect)
//	
//	sets up rect containing default window size
//	
//	theRect = pointer to rect which will recieve bounds
void MTListWindow::GetWindowSize(Rect * theRect)
{
	SInt32	temp;
	
	theRect->left = 0;
	theRect->top = 0;
	theRect->right = GetItemWidth();
	
	temp = GetItemHeight() * GetListLength();
	if(temp > qd.screenBits.bounds.bottom - 60)
		temp = qd.screenBits.bounds.bottom - 60;
	if(temp < (16 * 2 * 2) + 16)
		temp = (16 * 2 * 2) + 16;
	
	theRect->bottom = temp;
}

//	void MTListWindow::GetWindowStandardSize(Rect * theRect)
//	
//	sets up rect containing default window position
//	
//	theRect = pointer to rect which will recieve bounds
void MTListWindow::GetWindowStandardSize(Rect * theRect)
{
	theRect->left = 6;
	theRect->top = 42;
	theRect->right = theRect->left + GetItemWidth();
	theRect->bottom = qd.screenBits.bounds.bottom - 6;
}

//	void MTListWindow::GetWindowContentPadding(Rect * theRect)
//	
//	sets up rect containing padding applied to window scroll bars
void MTListWindow::GetWindowContentPadding(Rect * theRect)
{
	theRect->left = 0;
	theRect->top = 0;
	theRect->right = 0;
	theRect->bottom = 0;
}

//	void MTListWindow::DrawSimpleTextElement(SInt32 x, SInt32 y, StringPtr text, MTFontStyle * style)
//	
//	draws a simple text list item
//	
//	x = x base position
//	y = y base position
//	text = text to draw (pascal string)
//	style = pointer to target style
void MTListWindow::DrawSimpleTextElement(SInt32 x, SInt32 y, StringPtr text, MTFontStyle * style)
{
	MTFontSaver	fontSaver;
	
	if(style)
		style->SetCurrent();
	
	MoveTo(x + kTextElementXOffset, y + style->GetHeight() + kTextElementYOffset);
	DrawString(text);
}

//	void MTListWindow::DrawSimpleTextElement(SInt32 x, SInt32 y, char * buf, MTFontStyle * style)
//	
//	draws a simple text list item
//	
//	x = x base position
//	y = y base position
//	buf = text to draw (c-string)
//	style = pointer to target style
void MTListWindow::DrawSimpleTextElement(SInt32 x, SInt32 y, char * buf, MTFontStyle * style)
{
	MTFontSaver	fontSaver;
	
	if(style)
		style->SetCurrent();
	
	MoveTo(x + kTextElementXOffset, y + style->GetHeight() + kTextElementYOffset);
	DrawText(buf, 0, std::strlen(buf));
}

UInt8 MTListWindow::AutoHandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers)
{
	#pragma unused (theEvent)
	#pragma unused (keyCode)
	#pragma unused (modifiers)
	
	UInt8	handled = 0;
	
	if(SupportsSelection())
	{
		SInt32	selectionDelta = 0;
		SInt32	scrollDelta = 0;
		UInt8	needsUpdate = 0;
		
		handled = 1;
		
		switch(charCode)
		{
			case kUpArrowCharCode:
				selectionDelta = -1;
				break;
			
			case kDownArrowCharCode:
				selectionDelta = 1;
				break;
			
			case kPageUpCharCode:
				scrollDelta = -GetControlViewSize(vertScroll);
				break;
			
			case kPageDownCharCode:
				scrollDelta = GetControlViewSize(vertScroll);
				break;
			
			case kEnterCharCode:
			case kReturnCharCode:
				HandleListDoubleClick(selection);
				break;
			
			default:
				handled = 0;
				break;
		}
		
		if(selectionDelta)
		{
			selection += selectionDelta;
			
			if(selection < 0)
				selection = 0;
			
			if(selection >= GetListLength())
				selection = GetListLength() - 1;
			
			if(selection < GetControl32BitValue(vertScroll))
				scrollDelta = selection - GetControl32BitValue(vertScroll);
			
			if(selection >= GetControl32BitValue(vertScroll) + GetControlViewSize(vertScroll))
				scrollDelta = selection - (GetControl32BitValue(vertScroll) + GetControlViewSize(vertScroll)) + 1;
			
			SelectionChanged();
			
			needsUpdate = 1;
		}
		
		if(scrollDelta)
		{
			SInt32	value = GetControl32BitValue(vertScroll);
			
			value += scrollDelta;
			
			if(value < 0)
				value = 0;
			if(value > GetControl32BitMaximum(vertScroll))
				value = GetControl32BitMaximum(vertScroll);
			
			SetControl32BitValue(vertScroll, value);
			
			needsUpdate = 1;
		}
		
		if(needsUpdate)
		{
			HandleUpdateEvent();
		}
	}
	
	return !handled;
}